<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

$categorys 	= array();
foreach ((array)VBSIGNATURES::$cache['category'] as $categoryid => $category)
{
	$categorys[$categoryid] = $category['title'];
}
if (!count($categorys))
{
	// Missing categories
	print_stop_message('dbtech_vbsignatures_missing_x',
		$vbphrase['dbtech_vbsignatures_category'],
		$vbulletin->session->vars['sessionurl'],
		'category',
		'modify'
	);
}

$signaturestyles 	= array();
foreach ((array)VBSIGNATURES::$cache['signaturestyle'] as $signaturestyleid => $signaturestyle)
{
	$signaturestyles[$signaturestyleid] = $signaturestyle['title'];
}
if (!count($signaturestyles))
{
	// Missing categories
	print_stop_message('dbtech_vbsignatures_missing_x',
		$vbphrase['dbtech_vbsignatures_style'],
		$vbulletin->session->vars['sessionurl'],
		'signaturestyle',
		'modify'
	);
}

$layers 	= array();
foreach ((array)VBSIGNATURES::$cache['layer'] as $layerid => $layer)
{
	$layers[$layerid] = $layer['title'];
}
if (!count($layers))
{
	// Missing categories
	print_stop_message('dbtech_vbsignatures_missing_x',
		$vbphrase['dbtech_vbsignatures_layer'],
		$vbulletin->session->vars['sessionurl'],
		'layer',
		'modify'
	);
}

// #############################################################################
if ($_REQUEST['action'] == 'parts' OR empty($_REQUEST['action']))
{
	$parts_by_category = array();
	$parts_by_folder = array();
	foreach ((array)VBSIGNATURES::$cache['part'] as $partid => $part)
	{
		// Index by categoryid
		$parts_by_category[$part['categoryid']][$partid] = $part;
		
		// Index by folder
		$parts_by_folder[VBSIGNATURES::$cache['layer'][$part['layerid']]['folder']][$part['filename']] = true;
	}
	
	$layers_by_folder = array();
	foreach ((array)VBSIGNATURES::$cache['layer'] as $layerid => $layer)
	{
		$layers_by_folder[$layer['folder']] = $layerid;
	}
	
	// Grab the required file library
	require_once(DIR . '/dbtech/vbsignatures/includes/class_file.php');
	
	$allParts = VBSIGNATURES_FILE::fetchAllParts();
	foreach ($allParts as $folder => $images)
	{
		foreach ($images as $key => $image)
		{
			if (!$parts_by_folder[$folder][$image])
			{
				// Skip this
				continue;
			}
			
			// Get rid of this
			unset($allParts[$folder][$key]);
		}
		
		if (!count($allParts[$folder]))
		{
			// Get rid of this
			unset($allParts[$folder]);
		}
	}
	
	print_cp_header($vbphrase['dbtech_vbsignatures_part_management']);
	
	// Table header
	$headings = array();
	$headings[] = $vbphrase['title'];
	$headings[] = $vbphrase['display_order'];
	$headings[] = $vbphrase['dbtech_vbsignatures_category'];	
	$headings[] = $vbphrase['dbtech_vbsignatures_style'];	
	$headings[] = $vbphrase['dbtech_vbsignatures_price'];	
	
	if (count($allParts))
	{
		$i = 1;
		print_form_header('vbsignatures', 'parts');	
		construct_hidden_code('action', 'massadd');
		print_table_header($vbphrase['dbtech_vbsignatures_add_new_parts'], count($headings));
		foreach ($allParts as $folder => $images)
		{
			$displayorder = 10;
			
			print_description_row('/dbtech/vbsignatures/images/parts/' . $folder, false, count($headings), 'optiontitle');	
			print_cells_row($headings, 0, 'thead');			
			foreach ($images as $key => $filename)
			{
				// Table data
				$cell = array();
				$cell[] = '<input size="32" type="text" class="bginput" name="part[' . $i . '][title]" value="' . $filename . '" tabindex="1" /> ' . 
					construct_link_code($vbphrase['dbtech_vbsignatures_preview'], $vbulletin->options['bburl'] . '/dbtech/vbsignatures/images/parts/' . $folder . '/' . $filename, true);
				$cell[] = '<input size="8" type="text" class="bginput" name="part[' . $i . '][displayorder]" value="' . $displayorder . '" tabindex="1" />';
				$cell[] = '<select name="part[' . $i . '][categoryid]" tabindex="1" class="bginput">' . construct_select_options($categorys, $part['categoryid'], false) . '</select>';
				$cell[] = '<select name="part[' . $i . '][signaturestyleid]" tabindex="1" class="bginput">' . construct_select_options($signaturestyles, $part['signaturestyleid'], false) . '</select>';
				$cell[] = '<input size="8" type="text" class="bginput" name="part[' . $i . '][price]" value="10" tabindex="1" />';
				
				// Print the data
				print_cells_row($cell, 0, 0, -5, 'middle', 0, 1);
				
				construct_hidden_code('part[' . $i . '][layerid]', 		$layers_by_folder[$folder]);					
				construct_hidden_code('part[' . $i . '][filename]', 	$filename);					
				
				$i++;
				$displayorder += 10;
			}
		}
		print_submit_row($vbphrase['dbtech_vbsignatures_add_new_parts'], false, count($headings));	
	}
	
	// Table header
	$headings = array();
	$headings[] = $vbphrase['title'];
	$headings[] = $vbphrase['active'];
	$headings[] = $vbphrase['display_order'];
	$headings[] = $vbphrase['dbtech_vbsignatures_price'];
	
	// Hook goes here
	
	$headings[] = $vbphrase['edit'];
	$headings[] = $vbphrase['delete'];
	
	if (count($parts_by_category))
	{
		print_form_header('vbsignatures', 'parts');	
		construct_hidden_code('action', 'displayorder');
		print_table_header($vbphrase['dbtech_vbsignatures_part_management'], count($headings));
		print_description_row($vbphrase['dbtech_vbsignatures_part_management_descr'], false, count($headings));	
		
		foreach ($parts_by_category as $categoryid => $parts)
		{
			print_table_header(VBSIGNATURES::$cache['category'][$categoryid]['title'], count($headings));
			if (VBSIGNATURES::$cache['category'][$categoryid]['description'])
			{
				// Let's not try to print null descriptions, 'kay?
				print_description_row(VBSIGNATURES::$cache['category'][$categoryid]['description'], false, count($headings));
			}
			print_cells_row($headings, 0, 'thead');
			
			foreach ($parts as $partid => $part)
			{
				// Table data
				$cell = array();
				$cell[] = ($part['icon'] ? '<img src="../dbtech/vbsignatures/parts/' . $part['folder'] . '/' . $part['filename'] . '" alt="" /> ' : '') . $part['title'];
				$cell[] = ($part['active'] ? $vbphrase['yes'] : '<span class="col-i"><strong>' . $vbphrase['no'] . '</strong></span>');
				$cell[] = "<input type=\"text\" class=\"bginput\" name=\"order[$partid]\" value=\"$part[displayorder]\" tabindex=\"1\" size=\"3\" title=\"" . $vbphrase['edit_display_order'] . "\" />";
				$cell[] = $part['price'] . ' ' . $vbphrase['dbtech_vbsignatures_points'];

				// Hook goes here
				
				$cell[] = construct_link_code($vbphrase['edit'], 'vbsignatures.php?' . $vbulletin->session->vars['sessionurl'] . 'do=parts&amp;action=modify&amp;partid=' . $partid);
				$cell[] = construct_link_code($vbphrase['delete'], 'vbsignatures.php?' . $vbulletin->session->vars['sessionurl'] . 'do=parts&amp;action=delete&amp;partid=' . $partid);
				
				// Print the data
				print_cells_row($cell, 0, 0, -5, 'middle', 0, 1);
			}
		}
		
		print_submit_row($vbphrase['save_display_order'], false, count($headings));	
	}
}

// #############################################################################
if ($_REQUEST['action'] == 'modify')
{
	$partid = $vbulletin->input->clean_gpc('r', 'partid', TYPE_UINT);
	$part = ($partid ? VBSIGNATURES::$cache['part'][$partid] : false);
	
	if (!is_array($part))
	{
		// Non-existing part
		$partid = 0;
	}
	
	// Create array of usergroups
	$usergroups = array();
	foreach ((array)$vbulletin->usergroupcache as $usergroupid => $usergroup)
	{
		$usergroups[$usergroupid] = $usergroup['title'];
	}
	
	$headings = array(
		$vbphrase['usergroup'],
		$vbphrase['dbtech_vbsignatures_can_access']
	);	
	
	if ($partid)
	{
		// Edit
		print_cp_header(strip_tags(construct_phrase($vbphrase['dbtech_vbsignatures_editing_x_y'], $vbphrase['dbtech_vbsignatures_part'], $part['title'])));
		print_form_header('vbsignatures', 'parts');
		construct_hidden_code('action', 'update');
		construct_hidden_code('partid', $partid);
		print_table_header(construct_phrase($vbphrase['dbtech_vbsignatures_editing_x_y'], $vbphrase['dbtech_vbsignatures_part'], $part['title']));
	}
	else
	{
		// Add
		print_cp_header($vbphrase['dbtech_vbsignatures_add_new_part']);
		print_form_header('vbsignatures', 'parts');
		construct_hidden_code('action', 'update');
		print_table_header($vbphrase['dbtech_vbsignatures_add_new_part']);
	}
	
	print_description_row($vbphrase['dbtech_vbsignatures_main_settings'], false, 2, 'optiontitle');	
	print_input_row($vbphrase['title'], 									'part[title]', 									$part['title']);
	print_yes_no_row($vbphrase['active'],									'part[active]',									$part['active']);
	print_select_row($vbphrase['dbtech_vbsignatures_category'], 			'part[categoryid]', 		$categorys, 		$part['categoryid']);
	print_select_row($vbphrase['dbtech_vbsignatures_style'], 				'part[signaturestyleid]', 	$signaturestyles, 	$part['signaturestyleid']);		
	print_label_row($vbphrase['dbtech_vbsignatures_layer'], 																VBSIGNATURES::$cache['layer'][$part['layerid']]['title']);
	print_input_row($vbphrase['display_order'], 							'part[displayorder]', 							(isset($part['displayorder']) ? $part['displayorder'] : 10));
	print_input_row($vbphrase['filename'], 									'part[filename]', 								$part['filename']);
	print_input_row($vbphrase['dbtech_vbsignatures_price'], 				'part[price]', 									$part['price']);
	print_cells_row($headings, 0, 'thead');
	foreach ((array)$vbulletin->usergroupcache as $usergroupid => $usergroup)
	{
		print_yes_no_other_row($usergroup['title'], 'signaturestyle[permissions][' . $usergroupid . ']', $vbphrase['default'], (isset($signaturestyle['permissions'][$usergroupid]) ? $signaturestyle['permissions'][$usergroupid] : -1));
	}
	
	print_submit_row(($partid ? $vbphrase['save'] : $vbphrase['dbtech_vbsignatures_add_new_part']));
}

// #############################################################################
if ($_POST['action'] == 'massadd')
{
	// Grab stuff
	$vbulletin->input->clean_array_gpc('p', array(
		'part' => TYPE_ARRAY,
	));
	
	// part fields
	foreach ($vbulletin->GPC['part'] as $parts)
	{
		// init data manager
		$dm =& VBSIGNATURES::initDataManager('Part', $vbulletin, ERRTYPE_CP);
			
		foreach ($parts as $key => $val)
		{
			$dm->set($key, $val);
		}
			
		// Save! Hopefully.
		$dm->save();
		
		// Get rid of that
		unset($dm);			
	}
	
	define('CP_REDIRECT', 'vbsignatures.php?do=parts');
	print_stop_message('dbtech_vbsignatures_x_y', $vbphrase['dbtech_vbsignatures_parts'], $vbphrase['dbtech_vbsignatures_added']);
}

// #############################################################################
if ($_POST['action'] == 'update')
{
	// Grab stuff
	$vbulletin->input->clean_array_gpc('p', array(
		'partid' 	=> TYPE_UINT,
		'part' 		=> TYPE_ARRAY,
	));
	
	// init data manager
	$dm =& VBSIGNATURES::initDataManager('Part', $vbulletin, ERRTYPE_CP);
	
	// set existing info if this is an update
	if ($vbulletin->GPC['partid'])
	{
		if (!$existing = VBSIGNATURES::$cache['part'][$vbulletin->GPC['partid']])
		{
			// Couldn't find the part
			print_stop_message('dbtech_vbsignatures_invalid_x', $vbphrase['dbtech_vbsignatures_part'], $vbulletin->GPC['partid']);
		}
		
		// Set existing
		$dm->set_existing($existing);
				
		// Added
		$phrase = $vbphrase['dbtech_vbsignatures_edited'];
	}
	else
	{
		// Added
		$phrase = $vbphrase['dbtech_vbsignatures_added'];
	}
	
	// part fields
	foreach ($vbulletin->GPC['part'] AS $key => $val)
	{
		if (!$vbulletin->GPC['partid'] OR $existing[$key] != $val)
		{
			// Only set changed values
			$dm->set($key, $val);
		}
	}
	
	// Save! Hopefully.
	$dm->save();
		
	define('CP_REDIRECT', 'vbsignatures.php?do=parts');
	print_stop_message('dbtech_vbsignatures_x_y', $vbphrase['dbtech_vbsignatures_part'], $phrase);
}

// #############################################################################
if ($_POST['action'] == 'displayorder')
{
	$vbulletin->input->clean_array_gpc('p', array('order' => TYPE_ARRAY));
	
	if (is_array($vbulletin->GPC['order']))
	{
		foreach ($vbulletin->GPC['order'] as $partid => $displayorder)
		{
			if (!$existing = VBSIGNATURES::$cache['part'][$partid])
			{
				// Couldn't find the part
				continue;
			}
			
			if ($existing['displayorder'] == $displayorder)
			{
				// No change
				continue;
			}
			
			// init data manager
			$dm =& VBSIGNATURES::initDataManager('Part', $vbulletin, ERRTYPE_CP);
				$dm->set_existing($existing);
				$dm->set('displayorder', $displayorder);
			$dm->save();
			unset($dm);	
		}
	}
	
	define('CP_REDIRECT', 'vbsignatures.php?do=parts');
	print_stop_message('saved_display_order_successfully');	
}

// #############################################################################
if ($_REQUEST['action'] == 'delete')
{
	$vbulletin->input->clean_gpc('r', 'partid', TYPE_UINT);
	
	print_cp_header(construct_phrase($vbphrase['dbtech_vbsignatures_delete_x'], $vbphrase['dbtech_vbsignatures_part']));
	print_delete_confirmation('dbtech_vbsignatures_part', $vbulletin->GPC['partid'], 'vbsignatures', 'parts', 'dbtech_vbsignatures_part', array('action' => 'kill'), '', 'title');
	print_cp_footer();
}

// #############################################################################
if ($_POST['action'] == 'kill')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'partid' => TYPE_UINT,
		'kill' 		 => TYPE_BOOL
	));
	
	if (!$existing = VBSIGNATURES::$cache['part'][$vbulletin->GPC['partid']])
	{
		// Couldn't find the part
		print_stop_message('dbtech_vbsignatures_invalid_x', $vbphrase['dbtech_vbsignatures_part'], $vbulletin->GPC['partid']);
	}
	
	// init data manager
	$dm =& VBSIGNATURES::initDataManager('Part', $vbulletin, ERRTYPE_CP);
		$dm->set_existing($existing);
	$dm->delete();
	
	define('CP_REDIRECT', 'vbsignatures.php?do=parts');
	print_stop_message('dbtech_vbsignatures_x_y', $vbphrase['dbtech_vbsignatures_part'], $vbphrase['dbtech_vbsignatures_deleted']);	
}

/*======================================================================*\
|| #################################################################### ||
|| # Created: 16:52, Thu Sep 18th 2008								  # ||
|| # SVN: $Rev$									 					  # ||
|| #################################################################### ||
\*======================================================================*/
?>